/* This program is part of a faithfully-rounded, division-free l2
   vector norm with avoidance of spurious underflow and overflow.
   
   Author: Christoph Lauter,

           Université Pierre et Marie Curie Paris 6, UPMC, LIP6,
	   PEQUAN team.

   implementing the algorithm described in the paper

   Graillat, Lauter, Tang, Yamanaka and Oishi: Efficient calculations
   of faithfully rounded l2-norms of n-vectors.

   This program is

   Copyright (C) 2014 Université Pierre et Marie Curie Paris 6, UPMC,
   LIP6, PEQUAN team.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>. 

*/

#ifndef FAITHFULNORM_H
#define FAITHFULNORM_H

#include <stdint.h>

/* Compiler tricks and hints */
#define INLINE inline
#define RESTRICT restrict
#define STATIC static
#define CONST const

/* A constant always being false */
#define __ALWAYS_FALSE 0

/* Settings for the floating-point type 

   We are using double for now.

*/
#define PRECISION            (53)
#define BIAS                 (1023)
#define EXPO_MAX             (1023)
#define EXPO_MIN             (-1074)
#define EXPO_LEAST_NORMAL    (-1022)

#define SIGN_MASK            (0x7ff0000000000000ull)

/* Some values for testing */
#define EXPO_MIN_ONE_RANGE     (-5)
#define EXPO_MAX_ONE_RANGE      (5)
#define EXPO_MAX_SMALL_RANGE (-400)

/* A caster type */
typedef union _dblcast {
  double   d;
  uint64_t i;
} dblcast;

/* Declarations for the different functions */

double faithfulNorm(CONST double * RESTRICT, unsigned int);
double faithfulNorm2Bins(CONST double * RESTRICT, unsigned int);
double naiveNorm(CONST double * RESTRICT, unsigned int);
double netlibNorm(CONST double * RESTRICT, unsigned int);
double dummyFunc(CONST double * RESTRICT, unsigned int);

#endif /* inclusion guard FAITHFULNORM_H */
