/* This program is part of a faithfully-rounded, division-free l2
   vector norm with avoidance of spurious underflow and overflow.
   
   Author: Christoph Lauter,

           Université Pierre et Marie Curie Paris 6, UPMC, LIP6,
	   PEQUAN team.

   implementing the algorithm described in the paper

   Graillat, Lauter, Tang, Yamanaka and Oishi: Efficient calculations
   of faithfully rounded l2-norms of n-vectors.

   This program is

   Copyright (C) 2014 Université Pierre et Marie Curie Paris 6, UPMC,
   LIP6, PEQUAN team.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>. 

*/

#include "faithfulnormmpfr.h"

/* Implementation of a faithful norm using MPFR */
double faithfulNormMpfr(CONST double * RESTRICT x, unsigned int n) {
  mpfr_t acc, t, y;
  int i;
  double res;

  mpfr_init2(acc, (2 * EXPO_MAX) - (2 * EXPO_MIN) + 1 + (2 * PRECISION));
  mpfr_init2(t, (2 * PRECISION));
  mpfr_init2(y, PRECISION);
  
  mpfr_set_si(acc, 0, GMP_RNDN); /* exact */
  for (i=0; i<n; i++) {
    mpfr_set_d(t, x[i], GMP_RNDN); /* exact */
    mpfr_mul(t, t, t, GMP_RNDN); /* exact */
    mpfr_add(acc, acc, t, GMP_RNDN); /* exact */
  }
  mpfr_sqrt(y, acc, GMP_RNDN); /* one correct rounding */

  res = mpfr_get_d(y, GMP_RNDN); /* exact unless underflowing */

  mpfr_clear(acc);
  mpfr_clear(t);
  mpfr_clear(y);

  return res;
}

